### R code from vignette source 'optimalAllocation.Rnw'
### Encoding: UTF-8

###################################################
### code chunk number 1: optimalAllocation.Rnw:80-81
###################################################
library(optimalAllocation)


###################################################
### code chunk number 2: optimalAllocation.Rnw:96-97 (eval = FALSE)
###################################################
## ?OA


###################################################
### code chunk number 3: optimalAllocation.Rnw:172-173 (eval = FALSE)
###################################################
## ?plotExposedPeriods


###################################################
### code chunk number 4: optimalAllocation.Rnw:188-192 (eval = FALSE)
###################################################
## rhoes <- c(-0.2, 0, 0.5, 0.9)
## par(las = 1, mfrow = c(2, 2))
## for (i in 1:4)
##  plotExposedPeriods(r = 3, pe = 0.2, rhoe = rhoes[i])


###################################################
### code chunk number 5: figexposed
###################################################
rhoes <- c(-0.2, 0, 0.5, 0.9)
par(las = 1, mfrow = c(2, 2))
for (i in 1:4)
 plotExposedPeriods(r = 3, pe = 0.2, rhoe = rhoes[i])


###################################################
### code chunk number 6: optimalAllocation.Rnw:212-213
###################################################
rhoes <- c(-0.2, 0, 0.5, 0.9)
par(las = 1, mfrow = c(2, 2))
for (i in 1:4)
 plotExposedPeriods(r = 3, pe = 0.2, rhoe = rhoes[i])


###################################################
### code chunk number 7: optimalAllocation.Rnw:243-248
###################################################
study1 <- OA(target = "maxPower", pattern = "CMD", rMax = 20,
             theta = 0.5, rho = 0.7, sigma2 = 1, rhoe = 0.2, pe0 = 0.2,
             per = 0.3, piM = 0.2, kappa = 3, budget = 40, c1 = 1,
             beta = -0.3, alpha = 0.05)
study1


###################################################
### code chunk number 8: optimalAllocation.Rnw:256-257 (eval = FALSE)
###################################################
## plot(study1)


###################################################
### code chunk number 9: figstudy1
###################################################
par(las = 1, cex.lab = 1, oma = c(0, 0, 0, 0),
    mgp = c(1.8, 0.55, 0), mar = c(3, 3, 1, 1),
    cex.axis = 0.7)
plot(study1)


###################################################
### code chunk number 10: optimalAllocation.Rnw:273-274
###################################################
par(las = 1, cex.lab = 1, oma = c(0, 0, 0, 0),
    mgp = c(1.8, 0.55, 0), mar = c(3, 3, 1, 1),
    cex.axis = 0.7)
plot(study1)


###################################################
### code chunk number 11: optimalAllocation.Rnw:285-286
###################################################
summary(study1)


###################################################
### code chunk number 12: optimalAllocation.Rnw:301-306
###################################################
study2 <- OA(target = "minCost", pattern = "LDD", rMax = 20,
             theta = 0, rho = 0.6, sigma2 = 1, rhoe = 0.6, pe0 = 0.2,
             per = 0.2, piM = 0.2, kappa = 3, reqPower = 0.8, c1 = 50,
             beta = 0.8, alpha = 0.05)
study2


###################################################
### code chunk number 13: figstudy2
###################################################
par(las = 1, cex.lab = 1, oma = c(0, 0, 0, 0), mgp = c(1.8, 0.55, 0),
    mar = c(3, 3, 1, 1), cex.axis = 0.7)
plot(study2)


###################################################
### code chunk number 14: optimalAllocation.Rnw:321-322
###################################################
par(las = 1, cex.lab = 1, oma = c(0, 0, 0, 0), mgp = c(1.8, 0.55, 0),
    mar = c(3, 3, 1, 1), cex.axis = 0.7)
plot(study2)


###################################################
### code chunk number 15: optimalAllocation.Rnw:355-359
###################################################
study3 <- OA(target = "minCost", pattern = "CMD", rMax = 0, sigma2 = 1,
             pe0 = 0.3, reqPower = 0.9, c1 = 25, beta = -0.3,
             alpha = 0.05)
study3


###################################################
### code chunk number 16: optimalAllocation.Rnw:378-382
###################################################
study4 <- OA(target = "maxPower", pattern = "CMD", rMax = 0, sigma2 = 1,
             pe0 = 0.2, budget = 10000, c1 = 25, beta = -0.3,
             alpha = 0.05)
study4


###################################################
### code chunk number 17: optimalAllocation.Rnw:401-447
###################################################
# Creating scenarios:

res <- expand.grid(Exposure = c("Vacuuming", "Air freshener sprays"),
                   rho = c(0.3, 0.7))
res$pe0 <- 0.37
res$pe0[res$Exposure == "Air freshener sprays"] <- 0.17
res$per <- res$pe0
res$rhoe <- 0.13
res$rhoe[res$Exposure == "Air freshener sprays"] <- 0.60
res$TimeVaryingExposure <- TRUE
aux <- res
aux$TimeVaryingExposure <- FALSE
aux$rhoe <- 1
res <- rbind(res, aux)
res$r <- NA
res$N <- NA
res$cost <- NA

# Sorting the table:
ord <- order(res$Exposure, res$rho, 1 - res$TimeVaryingExposure)
res <- res[ord, ]
rownames(res) <- NULL

res

# Optimal allocation calculations
# for all scenarios:

studies <- list()

for (i in 1:nrow(res))
 {
  studies[[i]] <- OA(target = "minCost", pattern = "CMD", rMax = 20,
                     theta = 0.12, rho = res$rho[i], sigma2 = 0.43,
                     rhoe = res$rhoe[i], pe0 = res$pe0[i], per = res$per[i],
                     piM = 0.28, kappa = 2, reqPower = 0.9, c1 = 1,
                     beta = -0.39, alpha = 0.05)
  res$r[i] <- studies[[i]]$ropt
  res$N[i] <- studies[[i]]$Nopt
  res$cost[i] <- round(studies[[i]]$minCost, 1)
 }

# Results:

studyDesigns <- res[, -c(3:5)]
studyDesigns


###################################################
### code chunk number 18: optimalAllocation.Rnw:451-456
###################################################
costIncreasePercent <- 100*(studyDesigns$cost[2*(1:4)]/studyDesigns$cost[2*(1:4)-1] - 1)

maxcostIncreasePercentVacuuming <- round(max(costIncreasePercent[1:2]))

maxcostIncreasePercentSprays <- round(max(costIncreasePercent[3:4]))


###################################################
### code chunk number 19: costevolution
###################################################
par(las = 1, mfrow = c(2, 2), cex.lab = 0.8,
    oma = c(0, 0, 0, 0), mgp = c(1.8, 0.55, 0),
    mar = c(3.3, 3, 3.3, 1), cex.axis = 0.7)
for (i in c(1,3,5,7))
 {
  plot(studies[[i]], Ncex = 0.5)
  mtext(text = res$Exposure[i], side = 3, line = 1, cex = 0.8)
  mtext(text = bquote(paste(rho, sep = "") ==. (res$rho[i])), side = 3,
        line = 0, cex = 0.8)
 }


###################################################
### code chunk number 20: optimalAllocation.Rnw:478-479
###################################################
par(las = 1, mfrow = c(2, 2), cex.lab = 0.8,
    oma = c(0, 0, 0, 0), mgp = c(1.8, 0.55, 0),
    mar = c(3.3, 3, 3.3, 1), cex.axis = 0.7)
for (i in c(1,3,5,7))
 {
  plot(studies[[i]], Ncex = 0.5)
  mtext(text = res$Exposure[i], side = 3, line = 1, cex = 0.8)
  mtext(text = bquote(paste(rho, sep = "") ==. (res$rho[i])), side = 3,
        line = 0, cex = 0.8)
 }


###################################################
### code chunk number 21: optimalAllocation.Rnw:489-496 (eval = FALSE)
###################################################
## for (i in c(1,3,5,7))
##  {
##   plot(studies[[i]], Ncex = 0.5)
##   mtext(text = res$Exposure[i], side = 3, line = 1, cex = 0.8)
##   mtext(text = bquote(paste(rho, sep = "") ==. (res$rho[i])),
##         side = 3, line = 0, cex = 0.8)
##  }


